// priority: 25
let 全局箱子配置 = {
    // --- 全局箱子战利品修改配置 ---
    // 使用方法:
    //   - 移除列表: ["物品ID1", "物品ID2", ...]
    //   - 权重列表: [["物品ID", 权重值, (可选的NBT对象)], ...]
    //     - 权重物品默认掉落数量为1. 如果需要特定数量或范围, 请使用概率物品列表.
    //     - NBT对象示例: {display:{Name:'{"text":"特殊物品"}'}}
    //   - 抽取次数: [最小次数, 最大次数]
    //   - 概率列表: (参数按顺序可选, 但物品ID和基础概率是必须的)
    //     元素顺序:
    //     0: 物品ID (字符串)
    //     1: 基础概率 (数字, 0-1)
    //     2: 每点上下文幸运增加的概率 (数字, 或使用 null/undefined 来跳过此参数并提供后续参数)
    //     3: 数量数组 [最小, 最大] (数组, 或使用 null/undefined 来跳过此参数并提供后续参数, 默认为 [1,1])
    //     4: NBT数据 (对象, 或使用 null/undefined)
    //
    //     示例格式 (全局箱子配置.概率列表 和 箱子列表[...].概率列表 格式相同):
    //     - ["物品ID", 基础概率]                                (数量1, 不受幸运, 无NBT)
    //     - ["物品ID", 基础概率, [最小, 最大]]                  (指定数量, 不受幸运, 无NBT, 幸运增益参数省略或为null)
    //     - ["物品ID", 基础概率, 每点幸运增加概率]                  (数量1, 受幸运, 无NBT)
    //     - ["物品ID", 基础概率, 每点幸运增加概率, [最小, 最大]]    (指定数量, 受幸运, 无NBT)
    //     - ["物品ID", 基础概率, 每点幸运增加概率, [最小, 最大], {NBT}] (指定数量, 受幸运, 带NBT)
    //     - ["物品ID", 基础概率, null, [最小, 最大]]            (指定数量, 不受幸运(幸运参数为null), 无NBT)
    //     - ["物品ID", 基础概率, null, [最小, 最大], {NBT}]     (指定数量, 不受幸运(幸运参数为null), 带NBT)
    //     - ["物品ID", 基础概率, null, null, {NBT}]             (数量1, 不受幸运, 带NBT)
    //     - ["物品ID", 基础概率, 每点幸运增加概率, null, {NBT}]    (数量1, 受幸运, 带NBT)
    /*/let = 实验性物品列表移除 = [
        "enigmaticaddons:forger_gem", // 锻造者宝石
        "enigmaticaddons:artificial_flower" // 魔法石英花
    ]/*/
    移除列表: [
        "sophisticatedbackpacks:backpack",// 背包
        "croptopia:artichoke_seed",      // 洋蓟种子
        "croptopia:asparagus_seed",      // 芦笋种子
        "croptopia:barley_seed",         // 大麦种子
        "croptopia:basil_seed",          // 罗勒种子 (九层塔种子)
        "croptopia:bellpepper_seed",     // 甜椒种子 (灯笼椒种子)
        "croptopia:blackbean_seed",      // 黑豆种子
        "croptopia:blackberry_seed",     // 黑莓种子
        "croptopia:blueberry_seed",      // 蓝莓种子
        "croptopia:broccoli_seed",       // 西兰花种子
        "croptopia:cabbage_seed",        // 甘蓝种子 (卷心菜种子)
        "croptopia:cantaloupe_seed",     // 哈密瓜种子 (罗马甜瓜种子)
        "croptopia:cauliflower_seed",    // 花椰菜种子 (菜花种子)
        "croptopia:celery_seed",         // 芹菜种子
        "croptopia:chile_pepper_seed",   // 辣椒种子
        "croptopia:coffee_seed",         // 咖啡豆 (种子)
        "croptopia:corn_seed",           // 玉米种子
        "croptopia:cranberry_seed",      // 蔓越莓种子
        "croptopia:cucumber_seed",       // 黄瓜种子
        "croptopia:currant_seed",        // 醋栗种子 (红醋栗/黑醋栗)
        "croptopia:eggplant_seed",       // 茄子种子
        "croptopia:elderberry_seed",     // 接骨木莓种子
        "croptopia:garlic_seed",         // 大蒜种子
        "croptopia:ginger_seed",         // 姜种子
        "croptopia:grape_seed",          // 葡萄种子
        "croptopia:greenbean_seed",      // 青豆种子 (四季豆种子)
        "croptopia:greenonion_seed",     // 青葱种子 (小葱种子)
        "croptopia:honeydew_seed",       // 甘露瓜种子 (白兰瓜种子)
        "croptopia:hops_seed",           // 啤酒花种子
        "croptopia:kale_seed",           // 羽衣甘蓝种子
        "croptopia:kiwi_seed",           // 猕猴桃种子 (奇异果种子)
        "croptopia:leek_seed",           // 韭葱种子
        "croptopia:lettuce_seed",        // 生菜种子
        "croptopia:mustard_seed",        // 芥菜种子
        "croptopia:oat_seed",            // 燕麦种子
        "croptopia:olive_seed",          // 橄榄种子
        "croptopia:onion_seed",          // 洋葱种子
        "croptopia:peanut_seed",         // 花生种子
        "croptopia:pepper_seed",         // 胡椒种子
        "croptopia:pineapple_seed",      // 菠萝种子 (凤梨种子)
        "croptopia:radish_seed",         // 萝卜种子 (小红萝卜种子)
        "croptopia:raspberry_seed",      // 覆盆子种子 (树莓种子)
        "croptopia:rhubarb_seed",        // 大黄种子
        "croptopia:rice_seed",           // 水稻种子 (大米种子)
        "croptopia:rutabaga_seed",       // 瑞典芜菁种子 (大头菜种子)
        "croptopia:saguaro_seed",        // 巨人柱仙人掌种子
        "croptopia:soybean_seed",        // 大豆种子 (黄豆种子)
        "croptopia:spinach_seed",        // 菠菜种子
        "croptopia:squash_seed",         // 南瓜种子 (各种西葫芦/小南瓜的统称)
        "croptopia:strawberry_seed",     // 草莓种子
        "croptopia:sweetpotato_seed",    // 甘薯种子 (红薯/地瓜种子)
        "croptopia:tea_seed",            // 茶叶种子
        "croptopia:tomatillo_seed",      // 酸浆种子 (墨西哥小番茄种子)
        "croptopia:tomato_seed",         // 番茄种子 (西红柿种子)
        "croptopia:turmeric_seed",       // 姜黄种子
        "croptopia:turnip_seed",         // 芜菁种子 (萝卜种子)
        "croptopia:vanilla_seeds",       // 香草种子
        "croptopia:yam_seed",            // 山药种子
        "croptopia:zucchini_seed",       // 西葫芦种子 (夏南瓜种子)
        "farmersdelight:cabbage_seeds",  // 甘蓝种子 (卷心菜种子)
        "farmersdelight:rice",           // 稻米
        "farmersdelight:tomato_seeds",   // 番茄种子 (西红柿种子)
        "farmersdelight:rope",          // 绳索
        "minecraft:beetroot_seeds",    // 甜菜根种子
        "minecraft:melon_seeds",       // 西瓜种子
        "minecraft:pumpkin_seeds",     // 南瓜种子
        "minecraft:wheat_seeds",       // 小麦种子
        "minecraft:moss_block", // 苔藓块
        "mowziesmobs:foliaath_seed",   // 蔓藤怪种子
        "youkaishomecoming:green_coffee_bean", // 青咖啡豆
        "youkaishomecoming:mandrake_root",    // 曼德拉草根
        "youkaishomecoming:redbean",          // 红豆
        "youkaishomecoming:soybean",          // 大豆 (黄豆)
        "youkaishomecoming:tea_seeds",        // 茶叶种子
        "youkaishomecoming:udumbara_seeds",    // 优昙华种子
        "minecraft:wooden_hoe", // 木锄
        "minecraft:wooden_shovel", // 木铲
        "minecraft:wooden_pickaxe", // 木镐
        "minecraft:wooden_axe", // 木斧头
        "minecraft:wooden_sword", // 木剑
        "minecraft:stone_shovel", // 石锄
        "minecraft:stone_pickaxe", // 石镐
        "minecraft:stone_axe", // 石斧头
        "minecraft:stone_sword", // 石剑
        "minecraft:iron_hoe", // 铁锄
        "minecraft:iron_shovel", // 铁铲
        "minecraft:iron_pickaxe", // 铁镐
        "minecraft:iron_axe", // 铁斧头
        "minecraft:iron_sword", // 铁剑
        "minecraft:stick", // 木根
        "minecraft:paper", // 纸
        "minecraft:coal", // 煤炭
        "minecraft:book", // 书
        "minecraft:bone", // 骨头
        "minecraft:string", // 线
        "minecraft:arrow", // 箭
        "minecraft:rotten_flesh", // 腐肉
        "minecraft:sand", // 沙子
        "minecraft:spectral_arrow", // 光灵箭
        "minecraft:gold_nugget", // 金粒
        "minecraft:iron_nugget", // 铁粒
        "minecraft:glow_berries", // 发光浆果
        "minecraft:candle", // 蜡烛
        "minecraft:soul_torch", // 灵魂火把
        "minecraft:compass", // 指南针
        "minecraft:lead", // 拴绳
        "minecraft:amethyst_shard", // 紫水晶碎片
        "minecraft:diamond_horse_armor", // 钻石马铠
        "minecraft:disc_fragment_5", // 唱片碎片
        "minecraft:saddle", // 鞍
        "minecraft:beetroot_seeds", // 甜菜种子
        "minecraft:melon_seeds", // 西瓜种子
        "minecraft:rail", // 铁轨
        "minecraft:powered_rail", // 动力铁轨
        "minecraft:activator_rail", // 激活铁轨
        "minecraft:detector_rail", // 探测铁轨
        "minecraft:chain", // 锁链
        "minecraft:lava_bucket", // 熔岩桶
        "minecraft:crossbow", // 弩
        "minecraft:obsidian", // 黑曜石
        "minecraft:bone_block", // 骨块
        "minecraft:iron_pickaxe", // 铁镐
        "minecraft:iron_shovel", // 铁铲
        "minecraft:iron_sword", // 铁剑
        "minecraft:iron_helmet", // 铁头盔
        "minecraft:iron_chestplate", // 铁胸甲
        "minecraft:iron_leggings", // 铁护腿
        "minecraft:iron_boots", // 铁靴
        "minecraft:ender_eye", // 末影之眼
        "cataclysm:void_scatter_arrow", // 虚空散射箭
        "touhou_little_maid:shrine", // 神龛
        "enigmaticlegacy:recall_potion", // 召回药水
        "enigmaticaddons:void_tome", // 虚无之书
        "enigmaticaddons:forger_gem", // 锻造者宝石
        "minecraft:phantom_membrane", // 幻翼膜
        "enigmaticlegacy:lore_inscriber", // 设计师的墨水
        "enigmaticaddons:hell_blade_charm", // 地狱之刃护符
        "minecraft:golden_horse_armor", // 金马铠
        "minecraft:end_crystal", // 末地水晶
        "minecraft:sentry_armor_trim_smithing_template", // 哨兵盔甲纹饰锻造模板
        "minecraft:vex_armor_trim_smithing_template",   // 恼鬼盔甲纹饰锻造模板
        "minecraft:wild_armor_trim_smithing_template",  // 荒野盔甲纹饰锻造模板
        "minecraft:coast_armor_trim_smithing_template", // 海岸盔甲纹饰锻造模板
        "minecraft:dune_armor_trim_smithing_template",  // 沙丘盔甲纹饰锻造模板
        "minecraft:wayfinder_armor_trim_smithing_template",// 探路者盔甲纹饰锻造模板 
        "minecraft:raiser_armor_trim_smithing_template",// 牧育盔甲纹饰锻造模板 
        "minecraft:shaper_armor_trim_smithing_template",// 塑形盔甲纹饰锻造模板 
        "minecraft:host_armor_trim_smithing_template",  // 款待盔甲纹饰锻造模板 
        "minecraft:snout_armor_trim_smithing_template", // 嗅探盔甲纹饰锻造模板 
        "minecraft:eye_armor_trim_smithing_template",   // 眼眸盔甲纹饰锻造模板
        "minecraft:ward_armor_trim_smithing_template",  // 监守者盔甲纹饰锻造模板
        "minecraft:spire_armor_trim_smithing_template", // 尖塔盔甲纹饰锻造模板
        "minecraft:silence_armor_trim_smithing_template",// 静谧盔甲纹饰锻造模板
        "minecraft:rib_armor_trim_smithing_template",   // 肋骨盔甲纹饰锻造模板
        "minecraft:tide_armor_trim_smithing_template",  // 潮汐盔甲纹饰锻造模板

    ],
    权重列表: [
        ["minecraft:copper_ingot", 5], // 权重物品默认数量是1, 如果需要特定数量用概率列表
        ["create:zinc_ingot", 3],

        /*/["tacz:modern_kinetic_gun", 5, { // 权重为5
            AttachmentEXTENDED_MAG: { Count: "1b", id: "tacz:attachment", tag: { AttachmentId: "emxarms:emx_heavyweight_mag_3" } },
            AttachmentGRIP: { Count: "1b", id: "tacz:attachment", tag: { AttachmentId: "emxarms:grip_emx_extendsex" } },
            AttachmentMUZZLE: { Count: "1b", id: "tacz:attachment", tag: { AttachmentId: "emxarms:bayonet_emx_skyhunterax" } },
            AttachmentSCOPE: { Count: "1b", id: "tacz:attachment", tag: { AttachmentId: "tacz:scope_elcan_4x" } },
            AttachmentSTOCK: { Count: "1b", id: "tacz:attachment", tag: { AttachmentId: "emxarms:stock_emx_yield" } },
            GunCurrentAmmoCount: 65,
            GunFireMode: "AUTO",
            GunId: "emxarms:emx_rivet_gw",
            HasBulletInBarrel: "1b"
        }]
        ["tacz:attachment", 1, {AttachmentId:"emxarms:bayonet_emx_skyhunter_gw"}] // 带NBT的权重物品/*/
    ],
    抽取次数: [1, 2],
    概率列表: [
        ["kubejs:treasure_pouch1", 0.5, 0.1, [1, 3]], // 0.9基础P, 每幸运+0.1P, 掉2-5个
        ["kubejs:treasure_pouch2", 0.1, 0.1, [1, 1]], // 0.1基础P, 每幸运+0.5P, 掉1个
        // ["minecraft:apple", 0.1, null, [1,3], {display:{Name:'"美味苹果"'}}], // 10%概率掉1-3个命名苹果, 不受幸运
    ]
};

let 箱子列表 = [
    {
        标识符: "minecraft:chests/spawn_bonus_chest", // 奖励箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [
            "minecraft:oak_planks"
        ]
    },
    {
        标识符: "minecraft:chests/abandoned_mineshaft", // 废弃矿井宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.5, 0.1, [1, 3]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/ancient_city", // 远古城市宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.2, 0.05, [1, 2]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/ancient_city_ice_box", // 远古城市冰柜
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.25, 0.05, [1, 2]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/bastion_bridge", // 堡垒桥梁宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.35, 0.1, [1, 3]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/bastion_hoglin_stable", // 堡垒疣猪兽棚宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.2, 0.1, [1, 3]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/bastion_other", // 堡垒其他宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.1, 0.1, [1, 3]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/bastion_treasure", // 堡垒宝藏宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.3, 0.1, [1, 3]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/buried_treasure", // 埋藏的宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.35, 0.1, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/desert_pyramid", // 沙漠神殿宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.1, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/end_city_treasure", // 末地城宝藏
        权重列表: [
            ["enigmaticlegacy:etherium_ore", 0.5],
        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch5", 0.2, 0.05, [1, 2]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/igloo_chest", // 雪屋宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.6, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/jungle_temple", // 丛林神庙宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/jungle_temple_dispenser", // 丛林神庙发射器
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/nether_bridge", // 下界要塞宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/pillager_outpost", // 掠夺者前哨站宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/ruined_portal", // 废弃传送门宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/shipwreck_map", // 沉船地图箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/shipwreck_supply", // 沉船补给箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/shipwreck_treasure", // 船宝藏箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/simple_dungeon", // 地牢宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/stronghold_corridor", // 要塞走廊宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/stronghold_crossing", // 要塞十字路口宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/stronghold_library", // 要塞图书馆宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/trail_ruins_common", // 古迹废墟普通宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/trail_ruins_rare", // 古迹废墟稀有宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/underwater_ruin_big", // 大型水下遗迹宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.35, 0.05, [1, 1]],
            ["aquaculture:neptunium_ingot", 0.2, 0.1, [1, 1]], // 海王锭
            ["aquaculture:neptunium_nugget", 0.3, 0.1, [3, 5]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/underwater_ruin_small", // 小型水下遗迹宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
            ["aquaculture:neptunium_nugget", 0.25, 0.1, [1, 2]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_armorer", // 村庄盔甲匠宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_butcher", // 村庄屠夫宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_cartographer", // 村庄制图师宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_desert_house", // 村庄沙漠房屋宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_fisher", // 村庄渔夫宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_fletcher", // 村庄制箭师宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_librarian", // 村庄图书管理员宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_mason", // 村庄石匠宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_plains_house", // 村庄平原房屋宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_savanna_house", // 村庄热带草原房屋宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_shepherd", // 村庄牧羊人宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_snowy_house", // 村庄雪原房屋宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_taiga_house", // 村庄针叶林房屋宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_tannery", // 村庄制革匠宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_temple", // 村庄神殿宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_toolsmith", // 村庄工具匠宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/village/village_weaponsmith", // 村庄武器匠宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "minecraft:chests/woodland_mansion", // 林地府邸宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "adorabuild_structures:chests/beehive_loot", // 蜂箱战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "adorabuild_structures:chests/food_loot", // 食物相关战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "aquamirae:chests/frozen_chest", // 冰冻宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "aquamirae:chests/maze_camp_chest", // 迷宫营地宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "aquamirae:chests/maze_common_chest", // 迷宫普通宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "aquamirae:chests/ship_1", // 船只1宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "aquamirae:chests/ship_2", // 船只2宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel", // 营地木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/cobblestone", // 营地木桶/圆石
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/cobwebs", // 营地木桶/蜘蛛网
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/crops", // 营地木桶/作物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/food", // 营地木桶/食物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/gems", // 营地木桶/宝石
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/ingots", // 营地木桶/金属锭
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/minecarts", // 营地木桶/矿车
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/ores", // 营地木桶/矿石
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/rails", // 营地木桶/铁轨
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_barrel/tnt", // 营地木桶/TNT
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "artifacts:chests/campsite_chest", // 营地宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "awesomedungeonnether:chests/awesome_dungeon", // 宏伟下界地牢宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/beacon", // 改良要塞/信标
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/extra", // 改良要塞/额外
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/hall", // 改良要塞/大厅
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/keep", // 改良要塞/主楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/obsidian", // 改良要塞/黑曜石
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/puzzle", // 改良要塞/谜题
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/quarters", // 改良要塞/营房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/storage", // 改良要塞/储藏室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterfortresses:chests/worship", // 改良要塞/祭祀区
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "betteroceanmonuments:chests/upper_side_chamber", // 改良海底神殿/上层侧室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_ingot", 0.5, 0.1, [1, 2]], // 海王锭
        ],
        移除列表: [

        ]
    },
    {
        标识符: "betterwitchhuts:chests/hut_0", // 改良女巫小屋/小屋0
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "bosses_of_mass_destruction:chests/gauntlet", // 挑战赛宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "bosses_of_mass_destruction:chests/lich_tower", // 巫妖塔宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "bosses_of_mass_destruction:chests/obsidilith", // 黑曜石巨怪宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "cataclysm:chests/frosted_prison_treasure", // 霜冻监狱宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "deeperdarker:chests/ancient_temple_apex", // 远古神殿/顶端
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "deeperdarker:chests/ancient_temple_basement", // 远古神殿/地下室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "deeperdarker:chests/ancient_temple_fountain", // 远古神殿/喷泉
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "deeperdarker:chests/ancient_temple_storage", // 远古神殿/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "deeperdarker:chests/crystallized_amber", // 结晶琥珀宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/abandoned_temple/abandoned_temple_entrance", // 废弃神庙/入口
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/abandoned_temple/abandoned_temple_map", // 废弃神庙/地图
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/abandoned_temple/abandoned_temple_top", // 废弃神庙/顶部
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/aviary/aviary_barrels", // 鸟舍/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/aviary/aviary_normal", // 鸟舍/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/aviary/aviary_treasure", // 鸟舍/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_towers/bandit_towers_barrels", // 强盗塔楼/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_towers/bandit_towers_gardens", // 强盗塔楼/花园
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_towers/bandit_towers_normal", // 强盗塔楼/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_towers/bandit_towers_rooms", // 强盗塔楼/房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_towers/bandit_towers_supply", // 强盗塔楼/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_towers/bandit_towers_treasure", // 强盗塔楼/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_village/bandit_village_barrels", // 强盗村庄/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_village/bandit_village_normal", // 强盗村庄/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_village/bandit_village_supply", // 强盗村庄/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bandit_village/bandit_village_tents", // 强盗村庄/帐篷
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bathhouse/bathhouse_barrels", // 澡堂/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/bathhouse/bathhouse_normal", // 澡堂/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/ceryneian_hind/ceryneian_hind_treasure", // 刻律涅牝鹿/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/fishing_hut/fishing_hut_barrels", // 渔夫小屋/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/foundry/foundry_chains", // 铸造厂/锁链
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/foundry/foundry_lava_pit", // 铸造厂/熔岩坑
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/foundry/foundry_normal", // 铸造厂/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/foundry/foundry_passage_exterior", // 铸造厂/外部通道
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/foundry/foundry_passage_normal", // 铸造厂/普通通道
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/foundry/foundry_treasure", // 铸造厂/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/giant_mushroom/red_giant_mushroom", // 巨型蘑菇/红色
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/giant_mushroom/twin_giant_mushroom", // 巨型蘑菇/双子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_hallways", // 绿林酒馆/走廊木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/greenwood_pub/greenwood_pub_barrels_normal", // 绿林酒馆/普通木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/greenwood_pub/greenwood_pub_normal", // 绿林酒馆/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_normal", // 天堂挑战者/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch2", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_supply", // 天堂挑战者/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_theater", // 天堂挑战者/剧场
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_challenger/heavenly_challenger_treasure", // 天堂挑战者/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_barrels", // 天堂征服者/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_normal", // 天堂征服者/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_conqueror/heavenly_conqueror_treasure", // 天堂征服者/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_rider/heavenly_rider_barrels", // 天堂骑士/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_rider/heavenly_rider_normal", // 天堂骑士/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/heavenly_rider/heavenly_rider_treasure", // 天堂骑士/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_campsite/illager_campsite_map", // 灾厄村民营地/地图
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_campsite/illager_campsite_supply", // 灾厄村民营地/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_campsite/illager_campsite_tent", // 灾厄村民营地/帐篷
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_corsair/illager_corsair_barrels", // 灾厄村民海盗船/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_nugget", 0.2, 0.1, [2, 5]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_corsair/illager_corsair_supply", // 灾厄村民海盗船/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_ingot", 0.1, 0.1, [1, 1]], // 海王锭
            ["aquaculture:neptunium_nugget", 0.5, 0.1, [5, 8]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_corsair/illager_corsair_treasure", // 灾厄村民海盗船/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_ingot", 0.5, 0.1, [2, 3]], // 海王锭
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_fort/illager_fort_barrels", // 灾厄村民堡垒/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_fort/illager_fort_normal", // 灾厄村民堡垒/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_fort/illager_fort_treasure", // 灾厄村民堡垒/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_galley/illager_galley_barrels", // 灾厄村民桨帆船/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_galley/illager_galley_supply", // 灾厄村民桨帆船/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_galley/illager_galley_treasure", // 灾厄村民桨帆船/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_windmill/illager_windmill_barrels", // 灾厄村民风车/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/illager_windmill/illager_windmill_treasure", // 灾厄村民风车/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_room_bookshelf", // 神庙/书架房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_room_forge", // 神庙/锻造房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_room_garden", // 神庙/花园房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_room_normal", // 神庙/普通房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_room_supply", // 神庙/补给房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_room_table", // 神庙/桌子房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/infested_temple/infested_temple_top_treasure", // 神庙/顶部宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/jungle_tree_house/jungle_tree_house_barrels", // 丛林树屋/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/jungle_tree_house/jungle_tree_house_normal", // 丛林树屋/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/jungle_tree_house/jungle_tree_house_treasure", // 丛林树屋/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/keep_kayra/keep_kayra_garden_normal", // 凯拉要塞/花园普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/keep_kayra/keep_kayra_garden_treasure", // 凯拉要塞/花园宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/keep_kayra/keep_kayra_library_normal", // 凯拉要塞/图书馆普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/keep_kayra/keep_kayra_library_treasure", // 凯拉要塞/图书馆宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/keep_kayra/keep_kayra_normal", // 凯拉要塞/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/keep_kayra/keep_kayra_treasure", // 凯拉要塞/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/lighthouse/lighthouse_top", // 灯塔/顶部
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mechanical_nest/mechanical_nest_equipment", // 机械巢穴/装备
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mechanical_nest/mechanical_nest_normal", // 机械巢穴/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mechanical_nest/mechanical_nest_supply", // 机械巢穴/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch3", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mechanical_nest/mechanical_nest_treasure", // 机械巢穴/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/merchant_campsite/merchant_campsite_map", // 商人营地/地图
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/merchant_campsite/merchant_campsite_supply", // 商人营地/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/merchant_campsite/merchant_campsite_tent", // 商人营地/帐篷
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mines_treasure_big", // 矿井宝藏/大型
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mines_treasure_medium", // 矿井宝藏/中型
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mines_treasure_small", // 矿井宝藏/小型
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mining_system/mining_system_barrels", // 采矿系统/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mining_system/mining_system_treasure", // 采矿系统/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/monastery/monastery_barrels", // 修道院/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/monastery/monastery_bridges", // 修道院/桥梁
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/monastery/monastery_map", // 修道院/地图
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_house/mushroom_house_barrels", // 蘑菇房/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_house/mushroom_house_normal", // 蘑菇房/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_house/mushroom_house_treasure", // 蘑菇房/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_mines/mushroom_mines_barrels", // 蘑菇矿井/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_mines/mushroom_mines_ores", // 蘑菇矿井/矿石
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_mines/mushroom_mines_tools", // 蘑菇矿井/工具
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_mines/mushroom_mines_treasure", // 蘑菇矿井/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_village/mushroom_village_barrels", // 蘑菇村庄/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/mushroom_village/mushroom_village_treasure", // 蘑菇村庄/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/plague_asylum/plague_asylum_barrels", // 瘟疫避难所/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/plague_asylum/plague_asylum_cells", // 瘟疫避难所/牢房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/plague_asylum/plague_asylum_normal", // 瘟疫避难所/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/plague_asylum/plague_asylum_potions", // 瘟疫避难所/药水
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/plague_asylum/plague_asylum_storage", // 瘟疫避难所/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/plague_asylum/plague_asylum_treasure", // 瘟疫避难所/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/scorched_mines/scorched_mines_barrels", // 焦土矿井/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/scorched_mines/scorched_mines_housing", // 焦土矿井/住房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/scorched_mines/scorched_mines_hub", // 焦土矿井/中心
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/scorched_mines/scorched_mines_normal", // 焦土矿井/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/scorched_mines/scorched_mines_treasure", // 焦土矿井/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_elite", // 设拉子宫殿/精英
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_gardens", // 设拉子宫殿/花园
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_library", // 设拉子宫殿/图书馆
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_normal", // 设拉子宫殿/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_rooms", // 设拉子宫殿/房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_supply", // 设拉子宫殿/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_towers", // 设拉子宫殿/塔楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/shiraz_palace/shiraz_palace_treasure", // 设拉子宫殿/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/small_blimp/small_blimp_coal_storage", // 小型飞艇/煤炭储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/small_blimp/small_blimp_redstone_chamber", // 小型飞艇/红石室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/small_blimp/small_blimp_treasure", // 小型飞艇/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/small_prairie_house/small_prairie_house_barrels", // 草原小屋/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/small_prairie_house/small_prairie_house_normal", // 草原小屋/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/small_prairie_house/small_prairie_house_ruined", // 草原小屋/废墟
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/thornborn_towers/thornborn_towers_barrels", // 荆棘塔楼/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/thornborn_towers/thornborn_towers_rooms", // 荆棘塔楼/房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/thornborn_towers/thornborn_towers_top_rooms", // 荆棘塔楼/顶层房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/thornborn_towers/thornborn_towers_top_treasure", // 荆棘塔楼/顶层宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/typhon/typhon_treasure", // 堤丰/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_barrels", // 亡灵海盗船/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_nugget", 0.3, 0.1, [1, 2]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_enchants", // 亡灵海盗船/附魔
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_nugget", 0.1, 0.1, [2, 5]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_supply", // 亡灵海盗船/补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_nugget", 0.5, 0.1, [3, 6]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "dungeons_arise:chests/undead_pirate_ship/undead_pirate_ship_treasure", // 亡灵海盗船/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_ingot", 0.45, 0.1, [2, 3]], // 海王锭
        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_abandoned_mineshaft", // 废弃矿井
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_bastion_hoglin_stable", // 堡垒猪灵棚
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_bastion_treasure", // 堡垒宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_end_city_treasure", // 末地城宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_pillager_outpost", // 掠夺者前哨站
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_ruined_portal", // 废弃传送门
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_shipwreck_supply", // 沉船补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_simple_dungeon", // 简易地牢
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_village_butcher", // 村庄屠夫
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_village_desert_house", // 村庄沙漠房屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_village_plains_house", // 村庄平原房屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_village_savanna_house", // 村庄热带草原房屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_village_snowy_house", // 村庄雪原房屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "farmersdelight:chests/fd_village_taiga_house", // 村庄针叶林房屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/blacksmith_loot", // 铁匠铺战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/blacksmith_treasure", // 铁匠铺宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/crypt_book", // 地穴书本
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/crypt_loot", // 地穴战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/crypt_tomb", // 地穴坟墓
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/crypt_urn", // 地穴骨灰瓮
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/dark_manor_apothecary", // 黑暗庄园/药剂室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/dark_manor_attic", // 黑暗庄园/阁楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/dark_manor_clutter", // 黑暗庄园/杂物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/dark_manor_loom", // 黑暗庄园/织布机
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/dark_manor_treasure", // 黑暗庄园/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/graveyard_loot", // 墓地战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/graveyard_treasure", // 墓地宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/lair_loot", // 巢穴战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/lair_treasure", // 巢穴宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shack_attic", // 棚屋/阁楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shack_basement", // 棚屋/地下室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shack_book", // 棚屋/书本
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shack_potion", // 棚屋/药水
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shack_treasure", // 棚屋/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shrine_loot", // 神龛战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "goety:chests/shrine_treasure", // 神龛宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/arrow_loot", // 箭矢战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/bone_loot", // 骨头战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/brewing_loot", // 酿造战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/candle_loot", // 蜡烛战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/creeper_loot", // 苦力怕战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/crypt_loot", // 地穴战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/crypt_urn_loot", // 地穴骨灰瓮战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/desert_graveyard_loot", // 沙漠墓地战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/flesh_loot", // 腐肉战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/flower_loot", // 花朵战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/great_crypt_loot", // 大地穴战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/large_graveyard_loot", // 大型墓地战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/large_loot", // 大型战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/medium_graveyard_loot", // 中型墓地战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/medium_loot", // 中型战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/misc_loot", // 杂项战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/ore_loot", // 矿石战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/small_graveyard_loot", // 小型墓地战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/small_loot", // 小型战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/swamp_graveyard_loot", // 沼泽墓地战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/totem_loot", // 图腾战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "graveyard:chests/vase_loot", // 花瓶战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/illager_fort_ground", // 灾厄堡垒/地面
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/illager_fort_tower", // 灾厄堡垒/塔楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/illusioner_tower_entrance", // 幻术师塔/入口
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/illusioner_tower_stairs", // 幻术师塔/楼梯
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/labyrinth", // 迷宫
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/labyrinth_map", // 迷宫地图
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "illagerinvasion:chests/sorcerer_hut", // 巫师小屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/additional_ancient_city_loot", // 额外/远古城市战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/additional_generic_loot", // 额外/通用战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/additional_good_loot", // 额外/优质战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/additional_nether_loot", // 额外/下界战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/additional_treasure_loot", // 额外/宝藏战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/battleground/burial_loot", // 战场/墓葬战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/battleground/piglin_camp", // 战场/猪灵营地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/bookshelf_loot", // 书架战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/catacombs/armory_loot", // 地下墓穴/军械库
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/catacombs/coffin_loot", // 地下墓穴/棺材
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/catacombs/crypt_loot", // 地下墓穴/地穴
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/catacombs/hidden_trough_treasure", // 地下墓穴/隐藏水槽宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/catacombs/wall_loot", // 地下墓穴/墙壁
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/citadel/wall_loot", // 城堡/墙壁
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/component_storage", // 组件储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/evoker_fort", // 唤魔者堡垒
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/evoker_fort/guard_tower", // 唤魔者堡垒/守卫塔
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/filler_storage_loot", // 填充储藏战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/generic_magic_treasure", // 通用魔法宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/impaled_icebreaker/captain_quarters", // 被刺穿的破冰船/船长室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/impaled_icebreaker/food_barrel", // 被刺穿的破冰船/食物桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/magic_bookshelf_loot", // 魔法书架战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/mangrove_hut", // 红树林小屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/mangrove_hut/hidden_potion_storage", // 红树林小屋/隐藏药水储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/mangrove_hut/potion_ingredient_storage", // 红树林小屋/药水材料储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/mountain_tower/ice_barrel", // 高山塔楼/冰桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/mountain_tower/mountain_tower", // 高山塔楼/主塔
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/priest_house", // 牧师小屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/pyromancer_tower/burnt_chest", // 纵火者之塔/烧焦的箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/pyromancer_tower/fire_ale_cask", // 纵火者之塔/火焰麦酒桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/pyromancer_tower/fire_ale_trove", // 纵火者之塔/火焰麦酒秘藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/pyromancer_tower/old_cask", // 纵火者之塔/旧木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/pyromancer_tower/pyromancer_basic_storage", // 纵火者之塔/纵火者基础储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/pyromancer_tower/pyromancer_supplies", // 纵火者之塔/纵火者补给
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/sewer_loot", // 下水道战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "irons_spellbooks:chests/wheat", // 小麦
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "majruszsenchantments:chests/ancient_city_sixth_sense", // 远古城市/第六感
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "miners_delight:chests/md_abandoned_mineshaft", // 废弃矿井
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "mowziesmobs:chests/monastery_chest", // 修道院宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "mowziesmobs:chests/umvuthana_grove_chest", // 乌姆乌萨那树林宝箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/aurora_cache", // 极光秘藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/aurora_room", // 极光房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/basement", // 地下室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/darktower_boss", // 黑暗塔Boss
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/darktower_cache", // 黑暗塔秘藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/darktower_key", // 黑暗塔钥匙
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/fancy_well", // 华丽水井
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/foundation_basement", // 地基地下室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/graveyard", // 墓地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/hedge_maze", // 树篱迷宫
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/hill_1", // 小山1
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/hill_2", // 小山2
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/hill_3", // 小山3
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/labyrinth_dead_end", // 迷宫死路
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/labyrinth_room", // 迷宫房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/labyrinth_vault", // 迷宫宝库
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/labyrinth_vault_jackpot", // 迷宫宝库大奖
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/quest_grove_dropper", // 任务树林掉落物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/stronghold_boss", // 要塞Boss
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/stronghold_cache", // 要塞秘藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/stronghold_room", // 要塞房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/tower_library", // 塔楼图书馆
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/tower_room", // 塔楼房间
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/tree_cache", // 树木秘藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/troll_garden", // 巨魔花园
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/troll_vault", // 巨魔宝库
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/troll_vault_with_lamp", // 巨魔宝库带灯
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/useless", // 无用
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "twilightforest:chests/well", // 水井
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/abandoned_mineshaft", // 废弃矿井
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/bastion_treasure", // 堡垒宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/bonus_chest", // 奖励箱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/end_city", // 末地城
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/nether", // 下界
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/simple_dungeon", // 简易地牢
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/village_desert", // 村庄沙漠
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/village_plains", // 村庄平原
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/village_savanna", // 村庄热带草原
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/village_snowy", // 村庄雪原
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/village_taiga", // 村庄针叶林
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "vanillacookbook:chests/woodland_mansion", // 林地府邸
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/abandoned_small_castle/abandoned_small_castle_loot", // 废弃小城堡/战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/abandoned_small_castle/abandoned_small_castle_soldier", // 废弃小城堡/士兵
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/abandoned_small_castle/abandoned_small_castle_storage", // 废弃小城堡/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/badlands_dwelling/badlands_dwelling_bedroom", // 恶地住所/卧室
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/badlands_dwelling/badlands_dwelling_kitchen", // 恶地住所/厨房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/badlands_dwelling/badlands_dwelling_storage", // 恶地住所/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/bamboo_firework_site/bamboo_firework_site_gunpowder", // 竹林烟火场/火药
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/bamboo_firework_site/bamboo_firework_site_paper", // 竹林烟火场/纸
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/basalt_castle/basalt_castle_kitchen", // 玄武岩城堡/厨房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/basalt_castle/basalt_castle_loot", // 玄武岩城堡/战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/basalt_castle/basalt_castle_soldier", // 玄武岩城堡/士兵
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/basalt_castle/basalt_castle_storage", // 玄武岩城堡/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/basalt_castle/basalt_castle_wither", // 玄武岩城堡/凋灵
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/bee_farm/bee_farm", // 蜜蜂农场
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/beetroot_patch/beetroot_patch", // 甜菜地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/boats/common_river_boat", // 船只/普通内河船
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/candlemaker_house/candlemaker_house_bees", // 蜡烛匠房屋/蜜蜂
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/candlemaker_house/candlemaker_house_chest", // 蜡烛匠房屋/箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/candlemaker_house/candlemaker_house_shop", // 蜡烛匠房屋/商店
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/carrot_patch/carrot_patch", // 胡萝卜地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/chorus_orchard/chorus_orchard_arm", // 紫颂果园/臂
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/chorus_orchard/chorus_orchard_atrium", // 紫颂果园/中庭
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_desert_mill", // 混凝土磨坊废墟/沙漠磨坊
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_desert_water", // 混凝土磨坊废墟/沙漠水
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_shore_back", // 混凝土磨坊废墟/海岸后部
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/concrete_mill_ruins/concrete_mill_ruins_shore_mill", // 混凝土磨坊废墟/海岸磨坊
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/dark_witch_keep/dark_witch_keep", // 黑暗女巫要塞
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/firewatch_tower/firewatch_tower", // 瞭望塔
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/forgotten_remnants/forgotten_remnants_common", // 被遗忘的残迹/普通
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/forgotten_remnants/forgotten_remnants_echoes", // 被遗忘的残迹/回响
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/frost_reactor_plant/frost_reactor_plant_experiment", // 霜冻反应堆工厂/实验
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/frost_reactor_plant/frost_reactor_plant_military", // 霜冻反应堆工厂/军事
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_common_food", // 通用/普通食物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_common_storage", // 通用/普通储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_dispenser", // 通用/发射器
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_drinking_water", // 通用/饮用水
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_firework_dispenser", // 通用/烟火发射器
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_flame_dispenser", // 通用/火焰发射器
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/generic/generic_grave", // 通用/坟墓
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_bedside", // 地狱孤儿院/床头
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_kitchen", // 地狱孤儿院/厨房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_loot", // 地狱孤儿院/战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/hellish_orphanage/hellish_orphanage_storage", // 地狱孤儿院/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/hide_tannery/hide_tannery", // 皮革制革厂
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/hide_tannery/hide_tannery_cherry", // 皮革制革厂/樱桃木
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/ice_shanty/ice_shanty", // 冰上小屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/infested_castle/infested_castle_lesser", // 虫蚀城堡/次级
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/infested_castle/infested_castle_treasure", // 虫蚀城堡/宝藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/lighthouse/lighthouse", // 灯塔
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/llama_sanctuary/llama_sanctuary", // 羊驼圣所
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/llama_sanctuary/llama_sanctuary_hills", // 羊驼圣所/山丘
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/lumpy_tower/lumpy_tower", // 块状塔楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/marine_observation_hub/marine_observation_hub_kitchen", // 海洋观测中心/厨房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/marine_observation_hub/marine_observation_hub_quarters", // 海洋观测中心/营房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_nugget", 0.1, 0.1, [2, 5]], // 海王粒
        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/marine_observation_hub/marine_observation_hub_storage", // 海洋观测中心/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_ingot", 0.1, 0.1, [1, 1]], // 海王锭
        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/monster_egg_banquet/monster_egg_banquet", // 怪物蛋宴会
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/mossy_roof_house/mossy_roof_house_inside", // 苔藓屋顶房屋/内部
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/mossy_roof_house/mossy_roof_house_porch", // 苔藓屋顶房屋/门廊
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/mossy_roof_house/mossy_roof_house_wood", // 苔藓屋顶房屋/木材
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/mossy_roof_shed/mossy_roof_shed", // 苔藓屋顶棚屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/mushroom_house/mushroom_house", // 蘑菇房
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/old_fort/old_fort", // 旧堡垒
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/old_stable/old_stable", // 旧马厩
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/old_tiny_house/old_tiny_house", // 旧小屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/potato_patch/potato_patch", // 马铃薯地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/sandy_hidey_hole/sandy_hidey_hole", // 沙地藏身处
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/sphinx_hidey_hole/sphinx_hidey_hole_icy", // 狮身人面像藏身处/冰冷
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/spider_cellar/spider_cellar_potion", // 蜘蛛地窖/药水
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/spider_cellar/spider_cellar_storage", // 蜘蛛地窖/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/spruce_cabin/spruce_cabin", // 云杉小屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/spruce_cabin/spruce_cabin_secret", // 云杉小屋/秘密
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/strider_stable/strider_stable", // 炽足兽厩
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/sunken_steamboat/sunken_steamboat_loot", // 沉没蒸汽船/战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/sunken_steamboat/sunken_steamboat_storage", // 沉没蒸汽船/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/tall_birch_house/tall_birch_house", // 高大桦木房屋
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/tree_cage/tree_cage", // 树笼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/vigilante_fort/vigilante_fort_loot", // 治安官堡垒/战利品
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/vigilante_fort/vigilante_fort_storage", // 治安官堡垒/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/wandering_trader_cart/wandering_trader_cart_mineral", // 流浪商人货车/矿物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/wandering_trader_cart/wandering_trader_cart_plant", // 流浪商人货车/植物
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/wandering_trader_cart/wandering_trader_cart_value", // 流浪商人货车/有价值
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/wandering_trader_cart_cold/wandering_trader_cart_cold_shop", // 流浪商人货车寒冷/商店
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/wandering_trader_cart_cold/wandering_trader_cart_cold_storage", // 流浪商人货车寒冷/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/warped_ender_claw/warped_ender_claw", // 诡异末影之爪
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/wheat_patch/wheat_patch", // 小麦地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/woody_camp/woody_camp", // 林地营地
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/zen_chair_museum/zen_chair_museum_attic", // 禅意椅子博物馆/阁楼
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "wabi_sabi_structures:chests/zen_chair_museum/zen_chair_museum_storage", // 禅意椅子博物馆/储藏
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "youkaishomecoming:chests/cirno_nest/cabinet", // 琪露诺的巢穴/柜子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "youkaishomecoming:chests/hakurei_shrine/barrel", // 博丽神社/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "youkaishomecoming:chests/hakurei_shrine/cabinet", // 博丽神社/柜子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "youkaishomecoming:chests/hakurei_shrine/chest", // 博丽神社/箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "youkaishomecoming:chests/youkai_nest/barrel", // 妖怪巢穴/木桶
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "youkaishomecoming:chests/youkai_nest/chest", // 妖怪巢穴/箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/abandoned_villa", // 废弃别墅
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/balloon", // 气球
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/bees", // 蜜蜂
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/end_temple_chest", // 末地神殿箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/flooded_temple_chest", // 洪水神殿箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/guardian_meeting", // 守护者会议
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/harbour_chest", // 港口箱子
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/high_temple", // 高等神殿
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/infested_prison", // 虫蚀监狱
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/jungle_tower_chest", // 丛林塔箱子 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/mayan_temple", // 玛雅神庙 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/mineral_temple_chest", // 矿物神殿箱子 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/modern_villa", // 现代别墅 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.5, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/nether_pyramid_chest1", // 下界金字塔箱子1 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/nether_pyramid_chest2", // 下界金字塔箱子2 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/nether_shrine_chest", // 下界神殿箱子 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/nether_shrine_chest1", // 下界神殿箱子1 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/nether_shrine_chest2", // 下界神殿箱子2 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/oasis_shrine", //  绿洲神殿 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/oriental_hut_chest", // 东方小屋箱子 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/player_house_chest", // 玩家房屋箱子 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["kubejs:treasure_pouch4", 0.3, 0.05, [1, 1]],
        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/small_temple", // 小神庙 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/traderhouse", // 商人之家 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/watchtower", // 瞭望塔
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/water_shrine", // 水神殿
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [
            ["aquaculture:neptunium_ingot", 0.1, 0.1, [1, 1]], // 海王锭
        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/witch_house", // 女巫小屋 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
    {
        标识符: "shrines:chests/world_tree_manor", // 世界树庄园 
        权重列表: [

        ],
        抽取次数: [1, 2],
        概率列表: [

        ],
        移除列表: [

        ]
    },
];
